/*
 *  Gold.cpp
 *  BeeForaging
 *
 *  Created by Alan Dorin on 19/01/11.
 *  Copyright 2011 __MyCompanyName__. All rights reserved.
 *
 */
 
#include "Gold.h"

Gold::Gold()
{
	rewardAmount = 1;
	index = -1;
	position[vX] = position[vY] = position[vZ] = -1; 
}

Gold::Gold(const Gold& src)
{
	rewardAmount	= src.rewardAmount;
	index			= src.index;
	
	position[vX]	= src.position[vX];
	position[vY]	= src.position[vY];
	position[vZ]	= src.position[vZ];
}

Gold::~Gold()
{
	// ..
}

void Gold::setPosition(const long x, const long y, const long z)
{ position[vX] = x;	position[vY] = y; position[vZ] = z; }

long Gold::getPositionX(void)
{ return position[vX]; }

long Gold::getPositionY(void)
{ return position[vY]; }

long Gold::getPositionZ(void)
{ return position[vZ]; }

void Gold::setRewardAmount(long newReward)
{ rewardAmount = newReward;	}

long Gold::collectReward(void)
{
	long tmp = rewardAmount;
	rewardAmount = 0;
	
	return tmp;
}

long Gold::getIndex(void)
{ return index; }

void Gold::setIndex(long newIndex)
{ index = newIndex; }

void Gold::display(const SimpleVector& cellPosition, const SimpleVector& cellDimensions)
{
	SimpleVector yellow(0.9,0.9,0), black(0,0,0);
	SimpleVector insetDistance = cellDimensions/10.0;
	extern void writeTextString(const SimpleVector& rasterPosition, char* nameString);
	extern void drawWireSquare(const SimpleVector& position, const SimpleVector& dimensions);
	extern void drawFillSquare(const SimpleVector& position, const SimpleVector& dimensions);
	extern void drawMark(const SimpleVector& position);
	
	yellow.vector_gl_colour();
	
	if (rewardAmount>0)
	{
		drawFillSquare(cellPosition, cellDimensions-(insetDistance*8.0));
	}
	
	else
	{
		drawWireSquare(cellPosition, cellDimensions-(insetDistance*8.0));
	}
	
/*	black.vector_gl_colour();
	char theName[10];
	sprintf(theName, "%d", rewardAmount);
	writeTextString(cellPosition, theName);
*/
}

Gold& Gold::operator= (const Gold& rhs)
{
	position[vX]	= rhs.position[vX];
	position[vY]	= rhs.position[vY];
	position[vZ]	= rhs.position[vZ];
	
	rewardAmount = rhs.rewardAmount;
	index = rhs.index;
	return *this;
}

